import json
import psycopg2
import psycopg2.extras
import utils
import pandas as pd

conn = utils.common_prod_connection()
cursor = conn.cursor(cursor_factory=psycopg2.extras.DictCursor)

SEGMENTS = ['hahn', 'arnold', 'freud', 'zeno', 'vanga', 'seneca-sas', 'seneca-vla', 'seneca-man']

TYPES = ['hdd', 'ssd']

TYPES_BY_EXTERNAL_TYPE = {
    "hdd": ["hdd"],
    "ssd": ["ssd"],
    "chunk_count": ["hdd", "ssd"],
    "node_count": ["hdd", "ssd"]
}

COEF_BY_TYPE = {
    "hdd": {
        "numerator": 1,
        "denominator": 2 ** 20
    },
    "ssd": {
        "numerator": 1,
        "denominator": 2 ** 20
    },
    "node_count": {
        "numerator": 10,
        "denominator": 2 ** 40
    },
    "chunk_count": {
        "numerator": 1,
        "denominator": 512 * 2 ** 20
    },
}

table = pd.read_csv('3858/yt_prod_resources.csv')
res = {}
for i, row in table.iterrows():
    segment = row['cluster_segment_key']
    base_unit_key = row['base_unit_key']
    resource = row['resource_type_key']
    resource_id = row['resources_id']
    if segment not in SEGMENTS:
        continue
    if resource not in TYPES_BY_EXTERNAL_TYPE:
        continue

    types = TYPES_BY_EXTERNAL_TYPE[resource]
    coefs = COEF_BY_TYPE[resource]
    params = (coefs["numerator"], coefs["denominator"], resource_id, base_unit_key, segment, tuple(types))
    print(params)
    
    # cursor.execute("INSERT INTO resources_model_mapping(resource_id, segment_ids, campaign_id, numerator, denominator, external_resource_id, external_resource_unit_key, skip) " + \
    #     "SELECT r.id, ARRAY[sg.id], cr.campaign_id, %s, %s, %s, %s, false FROM resource r JOIN service s on r.service_id = s.id JOIN campaign_resource cr ON cr.resource_id = r.id " + \
    #     ", segment sg WHERE sg.key = %s AND r.key IN %s AND s.key = 'yt'", params)

conn.commit()