# "DISPENSER-5232"
import argparse
import json
from startrek_client import Startrek

parser = argparse.ArgumentParser()
parser.add_argument(
    "--token",
    help="OAuth token for Yandex Tracker",
    required=True
)
args = parser.parse_args()

client = Startrek(token=args.token, useragent="dispenser/scripts")

f = open('data.json')
data = json.load(f)
f.close()

for i in data:
    capacity_planner_login = i["capacity_planner_login"]
    service_ids = i["service_ids"]
    capacity_planner_abc_service_ids = i["capacity_planner_abc_service_ids"]
    ticket_ids = i["tickets"]

    capacity_planner_services = ""
    for service in capacity_planner_abc_service_ids:
        service_id = service['f1']
        service_key = service['f2']
        service_name = service['f3']
        capacity_planner_services += f"* ((https://abc.yandex-team.ru/services/{service_id} {service_name}))\n"

    tickets = ""
    tickets_summonees = set()
    for ticket in ticket_ids:
        ticket_id = ticket['f1']
        ticket_author = ticket['f2']
        tickets += f"* {ticket_id}\n"
        tickets_summonees.add(ticket_author)

    tickets_summonees.add(capacity_planner_login)
    tickets_summonees = list(tickets_summonees)

    new_ticket = client.issues.create(
        queue='DISPENSERREQ',
        type='task',
        parent='DISPENSER-5232',
        summary='Списание не забранных заказов',
        assignee=capacity_planner_login,
        description=f"Коллеги, пожалуйста, обратите внимание на то, что, "
                    f"если эти заказы не будут забраны до **1 июня 2022 года**, "
                    f"они будут списаны в пользу резерва провайдера.\n"
                    f"Подробности про списание заказов см. в https://clubs.at.yandex-team.ru/capacity-planning/209"
                    f"\n\n"
                    f"Так как Вы являетесь ответственным за Capacity Planning в сервисах:\n{capacity_planner_services}\n"
                    f"Вашего внимания требуют следующие заказы:\n{tickets}\n",
    )
    print("https://st.yandex-team.ru/" + new_ticket.key)

    client.issues.comments(new_ticket).create(
        text="Обратите внимание на списание не забранных заказов",
        summonees=tickets_summonees
    )
