SELECT
    json_build_object(
        'capacity_planner_login', capacity_planner_login,
        'service_ids', json_agg(DISTINCT row(raw.abc_service_id, p.key, p.short_name)),
        'capacity_planner_abc_service_ids', json_agg(DISTINCT row(raw.capacity_planner_abc_service_id, cps.key, cps.short_name)),
        'tickets', json_agg(DISTINCT row(qr.ticket_key, author.login))
        )
FROM quota_request_change qrc
         JOIN resource r ON qrc.resource_id = r.id
         JOIN service s ON r.service_id = s.id
         JOIN quota_request qr on qrc.quota_request_id = qr.id
         JOIN person author ON qr.author_id = author.id
         JOIN campaign c on c.id = qr.campaign_id
         JOIN project p on qr.project_id = p.id
         JOIN (
    VALUES (2922, 1415, 'prolog'),
           (3719, 871, 'ignition'),
           (2091, 4447, 'golubtsov'),
           (740, 36932, 'devamax'),
           (1772, 2015, 'mikari'),
           (31549, 31735, 'bahbka'),
           (2660, 850, 'glebskvortsov'),
           (185, 31735, 'bahbka'),
           (16, 32997, 'evelkin'),
           (109, 861, 'ignatich'),
           (859, 859, 'svyatoslav'),
           (578, 4447, 'golubtsov'),
           (2293, 4447, 'golubtsov'),
           (322, 322, 'mokhov'),
           (3185, 1005, 'korum'),
           (5558, 1455, 'avitella'),
           (1358, 861, 'ignatich'),
           (2306, 1415, 'prolog'),
           (1999, 2608, 'leftie'),
           (602, 1005, 'korum'),
           (1869, 31752, 'mvel'),
           (1488, 1488, 'slesarev'),
           (2107, 31752, 'mvel'),
           (32090, 850, 'glebskvortsov'),
           (5508, 1455, 'avitella'),
           (1439, 1439, 'tuxxon'),
           (1646, 1646, 'devamax'),
           (537, 1005, 'korum'),
           (4942, 4381, 'glebskvortsov'),
           (2910, 2913, 'mikari'),
           (287, 1005, 'korum'),
           (2678, 2015, 'mikari'),
           (579, 31752, 'mvel'),
           (1972, 863, 'khrolenko'),
           (5294, 31752, 'mvel'),
           (2831, 850, 'glebskvortsov'),
           (3578, 1005, 'korum'),
           (2252, 31752, 'mvel'),
           (3806, 1164, 'dkondra'),
           (5647, 1164, 'dkondra'),
           (692, 850, 'glebskvortsov'),
           (2634, 863, 'khrolenko'),
           (31349, 871, 'ignition'),
           (5522, 905, 'robot-market-mcrp'),
           (31660, 36932, 'devamax'),
           (871, 871, 'ignition'),
           (664, 31752, 'mvel'),
           (687, 1741, 'igogor'),
           (1168, 850, 'glebskvortsov'),
           (622, 1005, 'korum'),
           (374, 31752, 'mvel'),
           (741, 741, 'sereglond'),
           (1075, 1075, 'agodin'),
           (2868, 31752, 'mvel'),
           (31854, 35915, 'eatroshkin'),
           (68, 31752, 'mvel'),
           (4462, 905, 'robot-market-mcrp'),
           (2850, 863, 'khrolenko'),
           (470, 850, 'glebskvortsov'),
           (1975, 863, 'khrolenko'),
           (3793, 847, 'devamax'),
           (961, 850, 'glebskvortsov'),
           (4172, 1172, 'sereglond'),
           (1216, 905, 'robot-market-mcrp'),
           (2575, 506, 'mokhov'),
           (7495, 1415, 'prolog'),
           (401, 863, 'khrolenko'),
           (1209, 678, 'vag-ekaterina'),
           (4442, 871, 'ignition'),
           (3768, 1775, 'mosquito'),
           (1353, 31752, 'mvel'),
           (15882, 31752, 'mvel'),
           (1996, 36932, 'devamax'),
           (3296, 2015, 'mikari'),
           (28, 31752, 'mvel'),
           (989, 850, 'glebskvortsov'),
           (593, 1172, 'sereglond'),
           (291, 850, 'glebskvortsov'),
           (315, 1005, 'korum'),
           (310, 1005, 'korum'),
           (2016, 32997, 'evelkin'),
           (3807, 31752, 'mvel'),
           (1563, 24478, 'chertkova'),
           (15840, 1775, 'mosquito'),
           (6022, 1775, 'mosquito'),
           (506, 506, 'mokhov'),
           (31852, 35915, 'eatroshkin'),
           (31677, 4446, 'devamax'),
           (31857, 35915, 'eatroshkin'),
           (1423, 31735, 'bahbka'),
           (32065, 1005, 'korum'),
           (1775, 1775, 'mosquito'),
           (2110, 851, 'sereglond'),
           (2516, 2015, 'mikari'),
           (1762, 2015, 'mikari'),
           (7838, 1005, 'korum'),
           (1541, 1026, 'bahbka'),
           (4402, 36828, 'ortemij'),
           (31859, 35915, 'eatroshkin'),
           (4054, 1775, 'mosquito'),
           (2523, 861, 'ignatich'),
           (3834, 678, 'vag-ekaterina'),
           (1226, 31735, 'bahbka'),
           (987, 850, 'glebskvortsov'),
           (5878, 31752, 'mvel'),
           (698, 32997, 'evelkin'),
           (2578, 1005, 'korum'),
           (31763, 4446, 'devamax'),
           (1422, 1422, 'klakhman'),
           (4974, 32607, 'lupach'),
           (969, 905, 'robot-market-mcrp'),
           (1920, 31752, 'mvel'),
           (2235, 863, 'khrolenko'),
           (381, 850, 'glebskvortsov'),
           (1776, 1775, 'mosquito'),
           (2602, 1415, 'prolog'),
           (2857, 1775, 'mosquito'),
           (1561, 850, 'glebskvortsov'),
           (4859, 905, 'robot-market-mcrp'),
           (2027, 882, 'abroskin'),
           (1471, 31752, 'mvel'),
           (384, 847, 'devamax'),
           (1134, 31752, 'mvel'),
           (318, 31752, 'mvel'),
           (645, 861, 'ignatich'),
           (1932, 32607, 'lupach'),
           (439, 1172, 'sereglond'),
           (802, 905, 'robot-market-mcrp'),
           (187, 905, 'robot-market-mcrp'),
           (5080, 863, 'khrolenko'),
           (1613, 31752, 'mvel'),
           (90, 851, 'sereglond'),
           (2002, 24478, 'chertkova'),
           (2431, 2015, 'mikari'),
           (32101, 1005, 'korum'),
           (31032, 1005, 'korum'),
           (2088, 31752, 'mvel'),
           (31819, 1775, 'mosquito'),
           (1481, 31752, 'mvel'),
           (2224, 1415, 'prolog'),
           (5332, 847, 'devamax'),
           (758, 758, 'ortemij'),
           (1881, 1026, 'bahbka'),
           (3318, 4447, 'golubtsov'),
           (3602, 871, 'ignition'),
           (1037, 1005, 'korum'),
           (3708, 850, 'glebskvortsov'),
           (24567, 31752, 'mvel'),
           (1290, 31752, 'mvel'),
           (31853, 35915, 'eatroshkin'),
           (1347, 31735, 'bahbka'),
           (31437, 2015, 'mikari'),
           (4481, 871, 'ignition'),
           (31384, 905, 'robot-market-mcrp'),
           (2588, 863, 'khrolenko'),
           (2586, 31752, 'mvel'),
           (1662, 31735, 'bahbka'),
           (3305, 1775, 'mosquito'),
           (56, 31752, 'mvel'),
           (102, 31736, 'sgrb'),
           (2174, 2608, 'leftie'),
           (2522, 36932, 'devamax'),
           (2000, 31752, 'mvel'),
           (1238, 32997, 'evelkin'),
           (30680, 861, 'ignatich'),
           (979, 4447, 'golubtsov'),
           (1387, 31752, 'mvel'),
           (793, 32997, 'evelkin'),
           (2858, 1775, 'mosquito'),
           (2006, 887, 'terrmit'),
           (3494, 1172, 'sereglond'),
           (435, 35915, 'eatroshkin'),
           (823, 871, 'ignition'),
           (2190, 863, 'khrolenko'),
           (31851, 35915, 'eatroshkin'),
           (2472, 863, 'khrolenko'),
           (7812, 4447, 'golubtsov'),
           (700, 850, 'glebskvortsov'),
           (1128, 31736, 'sgrb'),
           (4517, 31752, 'mvel'),
           (4017, 2608, 'leftie'),
           (1851, 905, 'robot-market-mcrp'),
           (31229, 887, 'terrmit'),
           (5330, 895, 'agodin'),
           (895, 895, 'agodin'),
           (14, 4446, 'devamax'),
           (406, 847, 'devamax'),
           (1019, 905, 'robot-market-mcrp'),
           (1485, 24478, 'chertkova'),
           (336, 871, 'ignition'),
           (2430, 2015, 'mikari'),
           (31860, 35915, 'eatroshkin'),
           (31858, 35915, 'eatroshkin'),
           (173, 32997, 'evelkin'),
           (2402, 1775, 'mosquito'),
           (31966, 850, 'glebskvortsov'),
           (1424, 31752, 'mvel'),
           (3561, 32924, 'm12sl'),
           (2, 4447, 'golubtsov'),
           (1632, 905, 'robot-market-mcrp'),
           (968, 922, 'asimakov'),
           (1039, 1005, 'korum'),
           (675, 675, 'avitella'),
           (679, 850, 'glebskvortsov'),
           (1979, 1979, 'sereglond'),
           (909, 909, 'sterh'),
           (3852, 1775, 'mosquito'),
           (464, 922, 'asimakov')
)AS raw(abc_service_id, capacity_planner_abc_service_id, capacity_planner_login)
              ON raw.abc_service_id = p.abc_service_id
         LEFT JOIN project cps ON raw.capacity_planner_abc_service_id = cps.abc_service_id
WHERE qrc.amount_ready > qrc.amount_allocated + qrc.amount_allocating
  AND qr.status <> 'CANCELLED'
GROUP BY raw.capacity_planner_login
;
