import argparse
import json
import logging

import utils

utils.configure_logging("quota_request_updater.log")

TOKEN = utils.get_token('robot-dispenser')

parser = argparse.ArgumentParser()
parser.add_argument("-k", "--resource", type=str)
parser.add_argument("-p", "--provider", type=str, required=True) # provider key
parser.add_argument("-o", "--order", type=int) # order id
parser.add_argument("-c", "--campaign-order", type=int, required=True) # campaign order id
parser.add_argument("-s", "--segments", type=str) # segments separated by comma
parser.add_argument("-m", "--mode", type=str, required=True, choices=["BOTH", "READY", "ALLOCATED"]) # order id
parser.add_argument("-d", "--dry-run", default=False, type=bool, nargs="?", const=True) # dry run
parser.add_argument("-r", "--release", default=False, type=bool, nargs="?", const=True) # production

args = parser.parse_args()

dispenser = utils.Dispenser(args.release, cluster="common")

reqs = dispenser.get_requests(service=args.provider, status=["CONFIRMED"], campaignOrder=args.campaign_order).body

updates = []

for req in reqs:
    reqId = int(req['id'])
    change = {
        'serviceKey': args.provider
    }
    if args.resource:
        change['resourceKey'] = args.resource
    if args.segments:
        change['segmentKeys'] = args.segments.split(',')
    if args.order:
        change['orderId'] = args.order
    updates.append({
        "requestId": reqId,
        "changes": [
            change
        ]
    })

body = {
    "updateFor": args.mode,
    "updates": updates
}

if args.dry_run:
    print(json.dumps(body, indent=4))
else:
    logging.info(json.dumps(body))
    res = dispenser.set_quota_state_optional(body)
    logging.info(res.body)
