package ru.yandex.dispenser.validation;

import java.util.List;
import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import ru.yandex.dispenser.validation.client.CampaignType;
import ru.yandex.dispenser.validation.client.Result;
import ru.yandex.dispenser.validation.validator.Validator;

/**
 * Runner.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class Runner implements CommandLineRunner {

    private static final Logger LOG = LoggerFactory.getLogger(Runner.class);

    private final Validator validator;

    public Runner(Validator validator) {
        this.validator = validator;
    }

    @Override
    public void run(String... args) {
        LOG.info("Running validation for aggregated campaign...");
        List<Result<String>> aggregatedValidationResults = validator.validate(args[0], CampaignType.AGGREGATED).block();
        LOG.info("Running validation for draft campaign...");
        List<Result<String>> draftValidationResults = validator.validate(args[0], CampaignType.DRAFT).block();
        LOG.info("Validation finished, printing results...");
        LOG.info("Aggregated campaign results:");
        printResults(Objects.requireNonNull(aggregatedValidationResults));
        LOG.info("Draft campaign results:");
        printResults(Objects.requireNonNull(draftValidationResults));
        LOG.info("Finished");
    }

    private void printResults(List<Result<String>> results) {
        results.forEach(result -> result.match(
                providerName -> {
                    LOG.info("    {} validated successfully", providerName);
                    return null;
                },
                errors -> {
                    LOG.error("    {}", errors);
                    return null;
                }));
    }

}
