package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Amount.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class Amount {

    private final long value;
    private final String unit;

    @JsonCreator
    public Amount(@JsonProperty("value") long value,
                  @JsonProperty("unit") String unit) {
        this.value = value;
        this.unit = unit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Amount amount) {
        return new Builder(amount);
    }

    public long getValue() {
        return value;
    }

    public String getUnit() {
        return unit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Amount amount = (Amount) o;
        return value == amount.value &&
                Objects.equals(unit, amount.unit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, unit);
    }

    @Override
    public String toString() {
        return "Amount{" +
                "value=" + value +
                ", unit='" + unit + '\'' +
                '}';
    }

    public static final class Builder {

        private Long value;
        private String unit;

        private Builder() {
        }

        private Builder(Amount amount) {
            this.value = amount.value;
            this.unit = amount.unit;
        }

        public Builder value(long value) {
            this.value = value;
            return this;
        }

        public Builder unit(Units.Key unit) {
            this.unit = unit.getKey();
            return this;
        }

        public Amount build() {
            Objects.requireNonNull(value, "Value is required");
            Objects.requireNonNull(unit, "Unit is required");
            return new Amount(value, unit);
        }

    }

}
