package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Base resource.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class BaseResource {

    private final long id;
    private final String name;
    private final String key;
    private final Set<String> segmentKeys;
    private final BaseResourceType type;

    @JsonCreator
    public BaseResource(@JsonProperty("id") long id,
                        @JsonProperty("name") String name,
                        @JsonProperty("key") String key,
                        @JsonProperty("segmentKeys") Set<String> segmentKeys,
                        @JsonProperty("type") BaseResourceType type) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.segmentKeys = segmentKeys;
        this.type = type;
    }

    public long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getKey() {
        return key;
    }

    public Set<String> getSegmentKeys() {
        return segmentKeys;
    }

    public BaseResourceType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResource that = (BaseResource) o;
        return id == that.id &&
                Objects.equals(name, that.name) &&
                Objects.equals(key, that.key) &&
                Objects.equals(segmentKeys, that.segmentKeys) &&
                Objects.equals(type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, key, segmentKeys, type);
    }

    @Override
    public String toString() {
        return "BaseResource{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", key='" + key + '\'' +
                ", segmentKeys=" + segmentKeys +
                ", type=" + type +
                '}';
    }

}
