package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Base resource change.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class BaseResourceChange {

    private final BotBigOrder bigOrder;
    private final BaseResource baseResource;
    private final Amount totalAmount;
    private final Set<PerProviderBaseResourceAmount> perProviderAmounts;

    @JsonCreator
    public BaseResourceChange(
            @JsonProperty("bigOrder") BotBigOrder bigOrder,
            @JsonProperty("baseResource") BaseResource baseResource,
            @JsonProperty("totalAmount") Amount totalAmount,
            @JsonProperty("perProviderAmounts") Set<PerProviderBaseResourceAmount> perProviderAmounts) {
        this.bigOrder = bigOrder;
        this.baseResource = baseResource;
        this.totalAmount = totalAmount;
        this.perProviderAmounts = perProviderAmounts;
    }

    public BotBigOrder getBigOrder() {
        return bigOrder;
    }

    public BaseResource getBaseResource() {
        return baseResource;
    }

    public Amount getTotalAmount() {
        return totalAmount;
    }

    public Set<PerProviderBaseResourceAmount> getPerProviderAmounts() {
        return perProviderAmounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceChange that = (BaseResourceChange) o;
        return Objects.equals(bigOrder, that.bigOrder) &&
                Objects.equals(baseResource, that.baseResource) &&
                Objects.equals(totalAmount, that.totalAmount) &&
                Objects.equals(perProviderAmounts, that.perProviderAmounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bigOrder, baseResource, totalAmount, perProviderAmounts);
    }

    @Override
    public String toString() {
        return "BaseResourceChange{" +
                "bigOrder=" + bigOrder +
                ", baseResource=" + baseResource +
                ", totalAmount=" + totalAmount +
                ", perProviderAmounts=" + perProviderAmounts +
                '}';
    }

}
