package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Base resource type.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class BaseResourceType {

    private final long id;
    private final String name;
    private final String key;
    private final Service provider;

    @JsonCreator
    public BaseResourceType(@JsonProperty("id") long id,
                            @JsonProperty("name") String name,
                            @JsonProperty("key") String key,
                            @JsonProperty("provider") Service provider) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.provider = provider;
    }

    public long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getKey() {
        return key;
    }

    public Service getProvider() {
        return provider;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceType that = (BaseResourceType) o;
        return id == that.id &&
                Objects.equals(name, that.name) &&
                Objects.equals(key, that.key) &&
                Objects.equals(provider, that.provider);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, key, provider);
    }

    @Override
    public String toString() {
        return "BaseResourceType{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", key='" + key + '\'' +
                ", provider=" + provider +
                '}';
    }

}
