package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Campaign.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class Campaign {

    private final Long id;
    private final String key;
    private final String name;
    private final String status;

    @JsonCreator
    public Campaign(@JsonProperty("id") Long id,
                    @JsonProperty("key") String key,
                    @JsonProperty("name") String name,
                    @JsonProperty("status") String status) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.status = status;
    }

    public Long getId() {
        return id;
    }

    public String getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public String getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Campaign campaign = (Campaign) o;
        return Objects.equals(id, campaign.id) &&
                Objects.equals(key, campaign.key) &&
                Objects.equals(name, campaign.name) &&
                Objects.equals(status, campaign.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, name, status);
    }

    @Override
    public String toString() {
        return "Campaign{" +
                "id=" + id +
                ", key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", status='" + status + '\'' +
                '}';
    }

}
