package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Change.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class Change {

    private final Order order;
    private final Service service;
    private final Resource resource;
    private final Set<String> segmentKeys;
    private final Amount amount;
    private final Amount amountReady;
    private final Amount amountAllocated;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public Change(@JsonProperty("order") Order order,
                  @JsonProperty("service") Service service,
                  @JsonProperty("resource") Resource resource,
                  @JsonProperty("segmentKeys") Set<String> segmentKeys,
                  @JsonProperty("amount") Amount amount,
                  @JsonProperty("amountReady") Amount amountReady,
                  @JsonProperty("amountAllocated") Amount amountAllocated) {
        this.order = order;
        this.service = service;
        this.resource = resource;
        this.segmentKeys = segmentKeys;
        this.amount = amount;
        this.amountReady = amountReady;
        this.amountAllocated = amountAllocated;
    }

    public Order getOrder() {
        return order;
    }

    public Service getService() {
        return service;
    }

    public Resource getResource() {
        return resource;
    }

    public Set<String> getSegmentKeys() {
        return segmentKeys;
    }

    public Amount getAmount() {
        return amount;
    }

    public Amount getAmountReady() {
        return amountReady;
    }

    public Amount getAmountAllocated() {
        return amountAllocated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Change change = (Change) o;
        return Objects.equals(order, change.order) &&
                Objects.equals(service, change.service) &&
                Objects.equals(resource, change.resource) &&
                Objects.equals(segmentKeys, change.segmentKeys) &&
                Objects.equals(amount, change.amount) &&
                Objects.equals(amountReady, change.amountReady) &&
                Objects.equals(amountAllocated, change.amountAllocated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(order, service, resource, segmentKeys, amount, amountReady, amountAllocated);
    }

    @Override
    public String toString() {
        return "Change{" +
                "order=" + order +
                ", service=" + service +
                ", resource=" + resource +
                ", segmentKeys=" + segmentKeys +
                ", amount=" + amount +
                ", amountReady=" + amountReady +
                ", amountAllocated=" + amountAllocated +
                '}';
    }

}
