package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;

/**
 * Dispenser error.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface DispenserError {

    static DispenserError httpError(int statusCode) {
        return new DispenserError() {

            @Override
            public <R> R match(Cases<R> cases) {
                return cases.httpError(statusCode);
            }

            @Override
            public int hashCode() {
                return Objects.hash(statusCode);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof DispenserError)) {
                    return false;
                }
                final DispenserError error = (DispenserError) obj;
                return error.match(new Cases<>() {
                    @Override
                    public Boolean httpError(int otherStatusCode) {
                        return statusCode == otherStatusCode;
                    }

                    @Override
                    public Boolean httpTextError(int otherStatusCode, String otherText) {
                        return false;
                    }

                    @Override
                    public Boolean httpExtendedError(int otherStatusCode, DispenserErrorDescription otherDescription) {
                        return false;
                    }

                });
            }

            @Override
            public String toString() {
                return "DispenserError::httpError{"
                        + "statusCode=" + statusCode
                        + '}';
            }

        };
    }

    static DispenserError httpTextError(int statusCode, String text) {
        return new DispenserError() {

            @Override
            public <R> R match(Cases<R> cases) {
                return cases.httpTextError(statusCode, text);
            }

            @Override
            public int hashCode() {
                return Objects.hash(statusCode, text);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof DispenserError)) {
                    return false;
                }
                final DispenserError error = (DispenserError) obj;
                return error.match(new Cases<>() {
                    @Override
                    public Boolean httpError(int otherStatusCode) {
                        return false;
                    }

                    @Override
                    public Boolean httpTextError(int otherStatusCode, String otherText) {
                        return statusCode == otherStatusCode && Objects.equals(text, otherText);
                    }

                    @Override
                    public Boolean httpExtendedError(int otherStatusCode, DispenserErrorDescription otherDescription) {
                        return false;
                    }

                });
            }

            @Override
            public String toString() {
                return "DispenserError::httpTextError{"
                        + "statusCode=" + statusCode
                        + ", text=" + text
                        + '}';
            }

        };
    }

    static DispenserError httpExtendedError(int statusCode, DispenserErrorDescription description) {
        return new DispenserError() {

            @Override
            public <R> R match(Cases<R> cases) {
                return cases.httpExtendedError(statusCode, description);
            }

            @Override
            public int hashCode() {
                return Objects.hash(statusCode, description);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof DispenserError)) {
                    return false;
                }
                final DispenserError error = (DispenserError) obj;
                return error.match(new Cases<>() {
                    @Override
                    public Boolean httpError(int otherStatusCode) {
                        return false;
                    }

                    @Override
                    public Boolean httpTextError(int otherStatusCode, String otherText) {
                        return false;
                    }

                    @Override
                    public Boolean httpExtendedError(int otherStatusCode, DispenserErrorDescription otherDescription) {
                        return statusCode == otherStatusCode && Objects.equals(description, otherDescription);
                    }

                });
            }

            @Override
            public String toString() {
                return "DispenserError::httpExtendedError{"
                        + "statusCode=" + statusCode
                        + ", description=" + description
                        + '}';
            }

        };
    }

    <R> R match(Cases<R> cases);

    interface Cases<O> {

        O httpError(int statusCode);

        O httpTextError(int statusCode, String text);

        O httpExtendedError(int statusCode, DispenserErrorDescription description);

    }

}
