package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Dispenser error description.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DispenserErrorDescription {

    private final Long status;
    private final String title;
    private final String description;

    @JsonCreator
    public DispenserErrorDescription(@JsonProperty("status") Long status,
                                     @JsonProperty("title") String title,
                                     @JsonProperty("description") String description) {
        this.status = status;
        this.title = title;
        this.description = description;
    }

    public Long getStatus() {
        return status;
    }

    public String getTitle() {
        return title;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DispenserErrorDescription that = (DispenserErrorDescription) o;
        return Objects.equals(status, that.status) &&
                Objects.equals(title, that.title) &&
                Objects.equals(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, title, description);
    }

    @Override
    public String toString() {
        return "DispenserErrorDescription{" +
                "status=" + status +
                ", title='" + title + '\'' +
                ", description='" + description + '\'' +
                '}';
    }

}
