package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Per provider base resource amount.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class PerProviderBaseResourceAmount {

    private final Service provider;
    private final Amount amount;
    private final Set<Long> mappingIds;

    @JsonCreator
    public PerProviderBaseResourceAmount(@JsonProperty("provider") Service provider,
                                         @JsonProperty("amount") Amount amount,
                                         @JsonProperty("mappingIds") Set<Long> mappingIds) {
        this.provider = provider;
        this.amount = amount;
        this.mappingIds = mappingIds;
    }

    public Service getProvider() {
        return provider;
    }

    public Amount getAmount() {
        return amount;
    }

    public Set<Long> getMappingIds() {
        return mappingIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PerProviderBaseResourceAmount that = (PerProviderBaseResourceAmount) o;
        return Objects.equals(provider, that.provider) &&
                Objects.equals(amount, that.amount) &&
                Objects.equals(mappingIds, that.mappingIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(provider, amount, mappingIds);
    }

    @Override
    public String toString() {
        return "PerProviderBaseResourceAmount{" +
                "provider=" + provider +
                ", amount=" + amount +
                ", mappingIds=" + mappingIds +
                '}';
    }

}
