package ru.yandex.dispenser.validation.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Project.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class Project {

    private final String key;
    private final Long abcServiceId;

    @JsonCreator
    public Project(@JsonProperty("key") String key,
                   @JsonProperty("abcServiceId") Long abcServiceId) {
        this.key = key;
        this.abcServiceId = abcServiceId;
    }

    public String getKey() {
        return key;
    }

    public Long getAbcServiceId() {
        return abcServiceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project) o;
        return Objects.equals(key, project.key) &&
                Objects.equals(abcServiceId, project.abcServiceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, abcServiceId);
    }

    @Override
    public String toString() {
        return "Project{" +
                "key='" + key + '\'' +
                ", abcServiceId=" + abcServiceId +
                '}';
    }

}
