package ru.yandex.dispenser.validation.client.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Quota request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class QuotaRequest {

    private final long id;
    private final Project project;
    private final String description;
    private final String comment;
    private final String calculations;
    private final String author;
    private final String responsible;
    private final long created;
    private final long updated;
    private final Status status;
    private final Type type;
    private final List<Change> changes;
    private final Project sourceProject;
    private final List<String> chartLinks;
    private final String chartLinksAbsenceExplanation;
    private final Map<String, String> additionalProperties;
    private final Campaign campaign;
    private final Reason resourcePreorderReasonType;
    private final Goal goal;
    private final String summary;
    private final Set<BaseResourceChange> baseResourceChanges;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public QuotaRequest(@JsonProperty("id") long id,
                        @JsonProperty("project") Project project,
                        @JsonProperty("description") String description,
                        @JsonProperty("comment") String comment,
                        @JsonProperty("calculations") String calculations,
                        @JsonProperty("author") String author,
                        @JsonProperty("responsible") String responsible,
                        @JsonProperty("created") long created,
                        @JsonProperty("updated") long updated,
                        @JsonProperty("status") Status status,
                        @JsonProperty("type") Type type,
                        @JsonProperty("changes") List<Change> changes,
                        @JsonProperty("sourceProject") Project sourceProject,
                        @JsonProperty("chartLinks") List<String> chartLinks,
                        @JsonProperty("chartLinksAbsenceExplanation") String chartLinksAbsenceExplanation,
                        @JsonProperty("additionalProperties") Map<String, String> additionalProperties,
                        @JsonProperty("campaign") Campaign campaign,
                        @JsonProperty("resourcePreorderReasonType") Reason resourcePreorderReasonType,
                        @JsonProperty("goal") Goal goal,
                        @JsonProperty("summary") String summary,
                        @JsonProperty("baseResourceChanges") Set<BaseResourceChange> baseResourceChanges) {
        this.id = id;
        this.project = project;
        this.description = description;
        this.comment = comment;
        this.calculations = calculations;
        this.author = author;
        this.responsible = responsible;
        this.created = created;
        this.updated = updated;
        this.status = status;
        this.type = type;
        this.changes = changes;
        this.sourceProject = sourceProject;
        this.chartLinks = chartLinks;
        this.chartLinksAbsenceExplanation = chartLinksAbsenceExplanation;
        this.additionalProperties = additionalProperties;
        this.campaign = campaign;
        this.resourcePreorderReasonType = resourcePreorderReasonType;
        this.goal = goal;
        this.summary = summary;
        this.baseResourceChanges = baseResourceChanges;
    }

    public long getId() {
        return id;
    }

    public Project getProject() {
        return project;
    }

    public String getDescription() {
        return description;
    }

    public String getComment() {
        return comment;
    }

    public String getCalculations() {
        return calculations;
    }

    public String getAuthor() {
        return author;
    }

    public String getResponsible() {
        return responsible;
    }

    public long getCreated() {
        return created;
    }

    public long getUpdated() {
        return updated;
    }

    public Status getStatus() {
        return status;
    }

    public Type getType() {
        return type;
    }

    public List<Change> getChanges() {
        return changes;
    }

    public Project getSourceProject() {
        return sourceProject;
    }

    public List<String> getChartLinks() {
        return chartLinks;
    }

    public String getChartLinksAbsenceExplanation() {
        return chartLinksAbsenceExplanation;
    }

    public Map<String, String> getAdditionalProperties() {
        return additionalProperties;
    }

    public Campaign getCampaign() {
        return campaign;
    }

    public Reason getResourcePreorderReasonType() {
        return resourcePreorderReasonType;
    }

    public Goal getGoal() {
        return goal;
    }

    public String getSummary() {
        return summary;
    }

    public Set<BaseResourceChange> getBaseResourceChanges() {
        return baseResourceChanges;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaRequest that = (QuotaRequest) o;
        return id == that.id &&
                created == that.created &&
                updated == that.updated &&
                Objects.equals(project, that.project) &&
                Objects.equals(description, that.description) &&
                Objects.equals(comment, that.comment) &&
                Objects.equals(calculations, that.calculations) &&
                Objects.equals(author, that.author) &&
                Objects.equals(responsible, that.responsible) &&
                status == that.status &&
                type == that.type &&
                Objects.equals(changes, that.changes) &&
                Objects.equals(sourceProject, that.sourceProject) &&
                Objects.equals(chartLinks, that.chartLinks) &&
                Objects.equals(chartLinksAbsenceExplanation, that.chartLinksAbsenceExplanation) &&
                Objects.equals(additionalProperties, that.additionalProperties) &&
                Objects.equals(campaign, that.campaign) &&
                resourcePreorderReasonType == that.resourcePreorderReasonType &&
                Objects.equals(goal, that.goal) &&
                Objects.equals(summary, that.summary) &&
                Objects.equals(baseResourceChanges, that.baseResourceChanges);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, project, description, comment, calculations, author, responsible, created, updated,
                status, type, changes, sourceProject, chartLinks, chartLinksAbsenceExplanation, additionalProperties,
                campaign, resourcePreorderReasonType, goal, summary, baseResourceChanges);
    }

    @Override
    public String toString() {
        return "QuotaRequest{" +
                "id=" + id +
                ", project=" + project +
                ", description='" + description + '\'' +
                ", comment='" + comment + '\'' +
                ", calculations='" + calculations + '\'' +
                ", author='" + author + '\'' +
                ", responsible='" + responsible + '\'' +
                ", created=" + created +
                ", updated=" + updated +
                ", status=" + status +
                ", type=" + type +
                ", changes=" + changes +
                ", sourceProject=" + sourceProject +
                ", chartLinks=" + chartLinks +
                ", chartLinksAbsenceExplanation='" + chartLinksAbsenceExplanation + '\'' +
                ", additionalProperties=" + additionalProperties +
                ", campaign=" + campaign +
                ", resourcePreorderReasonType=" + resourcePreorderReasonType +
                ", goal=" + goal +
                ", summary='" + summary + '\'' +
                ", baseResourceChanges=" + baseResourceChanges +
                '}';
    }

}
