package ru.yandex.dispenser.validation.client.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Quota request list.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class QuotaRequestList {

    private final List<QuotaRequest> result;

    @JsonCreator
    public QuotaRequestList(@JsonProperty("result") List<QuotaRequest> result) {
        this.result = result;
    }

    public List<QuotaRequest> getResult() {
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaRequestList that = (QuotaRequestList) o;
        return Objects.equals(result, that.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(result);
    }

    @Override
    public String toString() {
        return "QuotaRequestList{" +
                "result=" + result +
                '}';
    }

}
