package ru.yandex.dispenser.validation.client.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Units.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class Units {

    public static final Map<String, Key> UNITS = allUnits();

    private Units() {
    }

    public interface Key {
        String getKey();
    }

    public enum BytesPerSecond implements Key {

        BYTES_PER_SECOND("BPS"),
        KILOBYTES_PER_SECOND("KBPS"),
        MEGABYTES_PER_SECOND("MBPS"),
        GIGABYTES_PER_SECOND("GBPS"),
        TERABYTES_PER_SECOND("TBPS");

        private final String key;

        BytesPerSecond(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return key;
        }

    }

    public enum BinaryBytesPerSecond implements Key {

        BINARY_BYTES_PER_SECOND("BINARY_BPS"),
        KIBIBYTES_PER_SECOND("KIBPS"),
        MEBIBYTES_PER_SECOND("MIBPS"),
        GIBIBYTES_PER_SECOND("GIBPS"),
        TEBIBYTES_PER_SECOND("TIBPS");

        private final String key;

        BinaryBytesPerSecond(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return key;
        }

    }

    public enum Bytes implements Key {

        BYTES("BYTE"),
        KIBIBYTES("KIBIBYTE"),
        MEBIBYTES("MEBIBYTE"),
        GIBIBYTES("GIBIBYTE"),
        TEBIBYTES("TEBIBYTE");

        private final String key;

        Bytes(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return key;
        }

    }

    public enum Count implements Key {

        PERMILLES("PERMILLE"),
        PERCENTS("PERCENT"),
        COUNT("COUNT"),
        KILO("KILO"),
        MEGA("MEGA"),
        GIGA("GIGA");

        private final String key;

        Count(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return key;
        }

    }

    public enum Cores implements Key {

        PERMILLE_CORES("PERMILLE_CORES"),
        PERCENT_CORES("PERCENT_CORES"),
        CORES("CORES"),
        KILO_CORES("KILO_CORES"),
        MEGA_CORES("MEGA_CORES"),
        GIGA_CORES("GIGA_CORES");

        private final String key;

        Cores(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return key;
        }

    }

    public enum Gibibytes implements Key {

        GIBIBYTES("GIBIBYTE_BASE"),
        TEBIBYTES("TEBIBYTE_BASE"),
        PEBIBYTE("PEBIBYTE_BASE"),
        EXBIBYTE("EXBIBYTE_BASE");

        private final String key;

        Gibibytes(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return key;
        }

    }

    private static Map<String, Key> allUnits() {
        Map<String, Key> result = new HashMap<>();
        List.of(BytesPerSecond.values()).forEach(v -> result.put(v.getKey(), v));
        List.of(BinaryBytesPerSecond.values()).forEach(v -> result.put(v.getKey(), v));
        List.of(Bytes.values()).forEach(v -> result.put(v.getKey(), v));
        List.of(Count.values()).forEach(v -> result.put(v.getKey(), v));
        List.of(Cores.values()).forEach(v -> result.put(v.getKey(), v));
        List.of(Gibibytes.values()).forEach(v -> result.put(v.getKey(), v));
        return result;
    }

}
