package ru.yandex.dispenser.validation.providers;

import java.util.Objects;

import ru.yandex.dispenser.validation.client.model.Units;

/**
 * Requested amount.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class RequestedAmount {

    private final long amount;
    private final Units.Key unit;

    public RequestedAmount(long amount, Units.Key unit) {
        this.amount = amount;
        this.unit = unit;
    }

    public long getAmount() {
        return amount;
    }

    public Units.Key getUnit() {
        return unit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequestedAmount that = (RequestedAmount) o;
        return amount == that.amount &&
                Objects.equals(unit, that.unit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, unit);
    }

    @Override
    public String toString() {
        return "RequestedAmount{" +
                "amount=" + amount +
                ", unit=" + unit +
                '}';
    }

}
