package ru.yandex.dispenser.validation.providers;

import java.util.Objects;

import ru.yandex.dispenser.validation.client.model.Units;

/**
 * Requested resource.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class RequestedResource {

    private final String key;
    private final Units.Key unit;

    public RequestedResource(String key, Units.Key unit) {
        this.key = key;
        this.unit = unit;
    }

    public String getKey() {
        return key;
    }

    public Units.Key getUnit() {
        return unit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequestedResource that = (RequestedResource) o;
        return Objects.equals(key, that.key) &&
                Objects.equals(unit, that.unit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, unit);
    }

    @Override
    public String toString() {
        return "ConfigurationResource{" +
                "key='" + key + '\'' +
                ", unit=" + unit +
                '}';
    }

}
