package ru.yandex.dispenser.validation.providers;

import java.util.Objects;
import java.util.Set;

/**
 * Segmented resource key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class SegmentedResourceKey {

    private final String providerKey;
    private final String resourceKey;
    private final Set<String> segmentKeys;

    public SegmentedResourceKey(String providerKey, String resourceKey, Set<String> segmentKeys) {
        this.providerKey = providerKey;
        this.resourceKey = resourceKey;
        this.segmentKeys = segmentKeys;
    }

    public String getProviderKey() {
        return providerKey;
    }

    public String getResourceKey() {
        return resourceKey;
    }

    public Set<String> getSegmentKeys() {
        return segmentKeys;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentedResourceKey that = (SegmentedResourceKey) o;
        return Objects.equals(providerKey, that.providerKey) &&
                Objects.equals(resourceKey, that.resourceKey) &&
                Objects.equals(segmentKeys, that.segmentKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerKey, resourceKey, segmentKeys);
    }

    @Override
    public String toString() {
        return "SegmentedResourceKey{" +
                "providerKey='" + providerKey + '\'' +
                ", resourceKey='" + resourceKey + '\'' +
                ", segmentKeys=" + segmentKeys +
                '}';
    }

}
