SET(spring-boot.version 2.6.6)
SET(log4j2.version 2.17.2)
SET(disruptor.version 3.4.4)
SET(xz.version 1.9)
SET(commons-compress.version 1.21)
SET(guava.version 31.0.1-jre)
SET(netty.version 4.1.75.Final)
SET(netty-tcnative.version 2.0.46.Final)
SET(jackson.version 2.13.2.20220328)
SET(kotlin-logging-jvm.version 2.1.0)
SET(kotlinx-coroutines.version 1.6.0)
SET(resilience4j.version 1.7.1)

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/springframework/boot/spring-boot-dependencies/${spring-boot.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/apache/logging/log4j/log4j-bom/${log4j2.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/io/netty/netty-bom/${netty.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/com/fasterxml/jackson/jackson-bom/${jackson.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/jetbrains/kotlinx/kotlinx-coroutines-bom/${kotlinx-coroutines.version}/ya.dependency_management.inc)
INCLUDE(${KOTLIN_BOM_FILE})

EXCLUDE(
    contrib/java/log4j/log4j
    contrib/java/org/springframework/boot/spring-boot-starter-logging
    contrib/java/org/springframework/boot/spring-boot-starter-tomcat
    contrib/java/commons-logging/commons-logging
    contrib/java/javax/activation/javax.activation-api
    contrib/java/javax/annotation/javax.annotation-api
    contrib/java/javax/websocket/javax.websocket-api
    contrib/java/javax/websocket/javax.websocket-client-api
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/javax/websocket/javax.websocket-client-api
    contrib/java/javax/websocket/javax.websocket-api
    contrib/java/javax/validation/validation-api
    contrib/java/org/apache/tomcat/embed/tomcat-embed-el
    contrib/java/com/sun/activation/javax.activation
    contrib/java/com/sun/mail/mailapi
)

DEPENDENCY_MANAGEMENT(
    contrib/java/com/lmax/disruptor/${disruptor.version}
    contrib/java/org/tukaani/xz/${xz.version}
    contrib/java/org/apache/commons/commons-compress/${commons-compress.version}
    contrib/java/com/google/guava/guava/${guava.version}
    contrib/java/io/netty/netty-transport-native-unix-common-linux-x86_64/${netty.version}
    contrib/java/io/netty/netty-tcnative-linux-x86_64/${netty-tcnative.version}
    contrib/java/io/netty/netty-tcnative-classes/${netty-tcnative.version}
    contrib/java/io/github/microutils/kotlin-logging-jvm/${kotlin-logging-jvm.version}
    contrib/java/io/github/resilience4j/resilience4j-kotlin/${resilience4j.version}
    contrib/java/io/github/resilience4j/resilience4j-retry/${resilience4j.version}
)

