# Почему коммиты не показываются?
## Коммиты неправильно подписаны
Коммиты соотносятся с пользователями на стаффе по email, например:
```
$ git show -q 666b1eb741c219e684ed23dc116fccee2620ff2a
commit 666b1eb741c219e684ed23dc116fccee2620ff2a
Author: arcadia-devtools <arcadia-devtools@yandex-team.ru>
Date:   Mon May 24 12:52:35 2021 +0300

    Solution files and make files updated
```
У автора этого коммита указан email ```arcadia-devtools@yandex-team.ru```, поэтому он припишется пользователю https://staff.yandex-team.ru/arcadia-devtools. 

Чтобы поле email правильно заполнялось при коммите в git, нужно предварительно правильно настроить git:
```$ git config --global user.email example@yandex-team.ru```

Email не обязательно должен быть в домене ```yandex-team.ru```, достаточно, чтобы он был указан в контактах пользователя на стаффе.

## Коммиты в приватном репозитории
Коммиты в приватные репозитории на внутренних github и bitbucket будут индексироваться, если к этим репозиториям есть доступ у робота https://staff.yandex-team.ru/robot-dogma. В списке коммитов в аркануме для них будет отображаться только статистика добавленных/удаленных строк, commit message видно не будет.
## Коммиты во внешнем репозитории
Коммиты в рабочие репозитории на github.com добавляются в список индексируемых по [запросу](https://st.yandex-team.ru/createTicket?queue=DEVTOOLSSUPPORT&_form=65090).
## Коммиты в удаленных ветках
Коммиты в ветках, которые были удаленны после мерджа пулл-реквеста, могут не успеть проиндексироваться. Лучше не удалять эти ветки, если необходимо иметь коммиты из них в общем списке коммитов. 
## Коммиты в пользовательских ветках
Коммиты в пользовательские arc-ветки не индексируются, но индексируются merge-коммиты из этих веток в trunk.
## Репозиторий в неиндексируемом источнике
Если репозитории, коммиты из которых необходимо индексировать, хостятся в отдельной инсталляции github/bitbucket/... -- [сообщите](https://st.yandex-team.ru/createTicket?queue=DEVTOOLSSUPPORT&_form=65090) об этом.
