from rest_framework.pagination import CursorPagination, LimitOffsetPagination

from django.conf import settings


class DogmaCursorPagination(CursorPagination):
    ordering = 'id'
    page_size = settings.DOGMA_API_CURSOR_PAGINATE_BY


class DogmaLimitOffsetPagination(LimitOffsetPagination):
    default_limit = 300
    max_limit = 5000
