# coding: utf-8

from rest_framework import serializers

from intranet.dogma.dogma.core.models import UserFileStatistics
from .user import UserSerializer


class UserFileStatisticsSerializer(serializers.ModelSerializer):
    user = UserSerializer()
    period = serializers.DateField(format="%m.%Y")

    class Meta:
        model = UserFileStatistics
        fields = 'user', 'extension', 'lines_added', 'lines_deleted', 'period',
