# coding: utf-8

from rest_framework import serializers

from intranet.dogma.dogma.api.serializers.git.commit import CommitSerializer


class ShortCommitSerializer(serializers.Serializer):
    sha = serializers.CharField()
    url = serializers.URLField()


class BranchSerializer(serializers.Serializer):
    """
    Краткая информация о бранче для списка
    """
    name = serializers.CharField()
    commit = ShortCommitSerializer()


class LinksSerializer(serializers.Serializer):
    self = serializers.URLField()


class DetailedBranchSerializer(BranchSerializer):
    commit = CommitSerializer()
    _links = LinksSerializer()
