# coding: utf-8

from rest_framework import serializers


class LinksSerializer(serializers.Serializer):
    """
    Дублирует ссылки в объекте _links
    """

    def get_attribute(self, content):
        return {
            'self': content['url'],
            'git': content['git_url'],
        }

    self = serializers.URLField()
    git = serializers.URLField()


class ContentSerializer(serializers.Serializer):
    """
    Без самого контента, для отображения содержимого директории или симлинок
    """
    type = serializers.CharField()
    size = serializers.IntegerField()
    name = serializers.CharField()
    path = serializers.CharField()
    sha = serializers.CharField()
    url = serializers.URLField()
    git_url = serializers.URLField()
    is_binary = serializers.BooleanField()
    _links = LinksSerializer()


class DetailedContentSerializer(ContentSerializer):
    encoding = serializers.CharField()
    content = serializers.CharField()
    download_url = serializers.URLField()


class SubmoduleContentSerializer(ContentSerializer):
    pass
    # Пока это нельзя достать
    # submodule_git_url = serializers.CharField()
