# coding: utf-8
from django.conf.urls import url

from intranet.dogma.dogma.api import views

owner_base = r'^repos/(?P<source>[\w\-]+)\:(?P<owner>[\w.\-~]+)'

repos_base = owner_base + r'/(?P<name>[\w._\- %]+?)'

urlpatterns = [
    url(r'^$', views.IndexView.as_view(), name='index'),
    url(r'^_nodes$', views.NodeListView.as_view(), name='nodes'),
    url(r'^repositories$',
        views.RepositoryListView.as_view(),
        name='all_repositories'),
    url(r'^search/commits/?$',
        views.CommitsSearchView.as_view(),
        name='commits_search'),
    url(r'^users/file_statistics/?$',
        views.UsersFileStatisticsView.as_view(),
        name='file_statistics'),
    url(r'^search/commits/count/?$',
        views.CommitsSearchCountView.as_view(),
        name='commits_search_count'),
    url(r'^(users|orgs)/(?P<source>[\w\-]+):(?P<owner>[\w.\-~]+)/repos$',
        views.UserRepositoryListView.as_view(),
        name='user_repositories'),
    url(owner_base + r'$',
        views.OwnerView.as_view(),
        name='owner'),
    url(repos_base + r'$',
        views.RepositoryView.as_view(),
        name='repository'),
    url(repos_base + r'/commits$',
        views.CommitListView.as_view(),
        name='commits'),
    url(repos_base + r'/branches$',
        views.BranchListView.as_view(),
        name='branches'),
    url(repos_base + r'/branches/(?P<branch_name>.+)$',
        views.BranchView.as_view(),
        name='branch'),
    url(r'^commits/(?P<sha>[0-9a-f]+)/?$',
        views.CommitView.as_view(),
        name='commit'),
    url(repos_base + r'/contents/(?P<path>.*)$',
        views.ContentView.as_view(),
        name='contents'),
    url(repos_base + r'/blobs/(?P<sha>[0-9a-f]+)$',
        views.BlobView.as_view(),
        name='blob'),
    url(repos_base + r'/raw/(?P<sha>[0-9a-f]+)/(?P<path>.+)$',
        views.RawView.as_view(),
        name='raw'),
    url(repos_base + r'/compare/(?P<old_branch_or_tag_or_sha>.+?)\.\.\.(?P<new_branch_or_tag_or_sha>.+)$',
        views.CompareView.as_view(),
        name='compare'),
    url(repos_base + r'/forks$',
        views.ForksView.as_view(),
        name='forks'),
    url(repos_base + r'/languages$',
        views.LanguagesView.as_view(),
        name='languages'),
    url(repos_base + r'/contributors$',
        views.ContributorsView.as_view(),
        name='contributors'),
    url(repos_base + r'/readme$',
        views.ReadmeView.as_view(),
        name='readme'),
    url(r"^by_months/?$",
        views.CommitsStatByMonthsView.as_view(),
        name="by_months"),
    url(r"^heatmap/?$",
        views.CommitsHeatmap.as_view(),
        name="heatmap"),
]
