# coding: utf-8
from django.core.urlresolvers import reverse
from django.http import Http404

from rest_framework.response import Response

from intranet.dogma.dogma.core.git.models import Blob
from intranet.dogma.dogma.api.framework import RepoAPIView
from intranet.dogma.dogma.api import serializers
from intranet.dogma.dogma.api.utils import make_absolute_url


class BlobView(RepoAPIView):
    """
    Блоб
    """

    serializer_class = serializers.BlobSerializer

    def get(self, request, source, owner, name, sha):
        try:
            blob = self.raw[str(sha)]
        except KeyError:
            raise Http404("blob not found")

        if not isinstance(blob, Blob):
            raise Http404("sha is not a blob")

        encoding, blob_data = blob.encode_data()

        data = {
            'url': make_absolute_url(request, reverse('api:blob', args=[source, owner, name, sha])),
            'sha': blob.hex,
            'size': blob.size,
            'encoding': encoding,
            'content': blob_data,
        }

        return Response(self.get_serializer(data).data)
