# coding: utf-8
import re

from rest_framework.response import Response
from rest_framework.reverse import reverse
from rest_framework.generics import GenericAPIView

from intranet.dogma.dogma.api.framework import APIView
from intranet.dogma.dogma.core.dao.repo import get_failed_repos, get_straggled_repos
from intranet.dogma.dogma.core.dao.clones import get_clones_on_current_node
from intranet.dogma.dogma.core.dao.source import get_failed_sources
from intranet.dogma.dogma.core.models import Clone


def simplify_regex(pattern):
    """
    Визуально упрощает паттерн для отображения пользователю
    """

    pattern = pattern.lstrip('^').rstrip('$')
    # Поменять (?<field_name>[\w\-]+) на {field_name}
    pattern = re.sub(r'\(\?P\<(?P<name>\w+)\>[^\)]+\)', '{\g<name>}', pattern)
    return pattern


class IndexView(APIView):
    """
    Все доступные ручки API
    """

    def get(self, request, *args, **kwargs):
        from intranet.dogma.dogma.api.urls import urlpatterns

        base_api_url = reverse('api:index', request=request)

        urls = {
            entry.name: base_api_url + simplify_regex(entry.regex.pattern)
            for entry in urlpatterns
            if entry.name != 'index'
        }

        return Response(urls)


class UnistatView(GenericAPIView):
    no_auth = True
    no_org = True

    def get(self, request, *args, **kwargs):
        data = [
            ["failed_repos_alltime_ahhh", get_failed_repos().count()],
            ["straggled_repos_alltime_ahhh", get_straggled_repos().count()],
            ["failed_important_repos_alltime_ahhh", get_failed_repos(important=True).count()],
            ["straggled_important_repos_alltime_ahhh", get_straggled_repos(important=True).count()],
            ["failed_clones_alltime_ahhh",
             get_clones_on_current_node(status=Clone.STATUSES.fail).count()],
            ["success_clones_alltime_ahhh",
             get_clones_on_current_node(status=Clone.STATUSES.active).count()],
            ["failed_sources_alltime_ahhh",
             get_failed_sources().count()],
        ]
        return Response(data)
