# coding: utf-8


from rest_framework.renderers import JSONRenderer
from rest_framework.exceptions import APIException
from rest_framework import generics

from intranet.dogma.dogma.api.framework import APIView
from intranet.dogma.dogma.api import serializers
from intranet.dogma.dogma.core.models import UserFileStatistics
from intranet.dogma.dogma.api.logic.query import prepare_date
from ..pagination import DogmaCursorPagination


class UsersFileStatisticsView(APIView, generics.ListAPIView):
    renderer_classes = JSONRenderer,
    serializer_class = serializers.UserFileStatisticsSerializer
    pagination_class = DogmaCursorPagination

    def get_queryset(self):
        uid = self.request.query_params.get('uid')
        period = self.request.query_params.get('period')
        if not (period or uid):
            error = 'You have to specify uid or period'
            raise APIException(error)
        queryset = UserFileStatistics.objects.all().select_related('user')
        if uid:
            uids = uid.split(',')
            queryset = queryset.filter(user__uid__in=uids)
        if period:
            try:
                month_from, month_to = (
                    prepare_date(date).replace(day=1)
                    for date in period.split(',')
                )
            except ValueError:
                error = 'Invalid period format: {}, should be &period=YYYY-MM-DD,YYYY-MM-DD'.format(period)
                raise APIException(error)
            queryset = queryset.filter(period__range=[month_from, month_to])

        return queryset


