# coding: utf-8
from intranet.dogma.dogma.api import serializers
from intranet.dogma.dogma.api.framework import RepoAPIView
from .repository import RepositoryListMixin


class ForksView(RepositoryListMixin, RepoAPIView):
    serializer_class = serializers.RepositorySerializer

    def get_queryset(self):
        repo = self.repo.repository
        return repo.forks.all().select_related('source')

    def get(self, request, *args, **kwargs):
        return self.list(request, *args, **kwargs)
