# coding: utf-8

from rest_framework.response import Response

from intranet.dogma.dogma.api.framework import APIView
from intranet.dogma.dogma.api import serializers
from intranet.dogma.dogma.core.models import Node


class NodeListView(APIView):
    """
    Все доступные ноды
    """
    serializer_class = serializers.NodeSerializer

    def get(self, request, *args, **kwargs):
        qs = Node.objects.filter(enabled=True)

        return Response(self.get_serializer(qs, many=True).data)
