# coding: utf-8



from django.http import Http404

from intranet.dogma.dogma.api.framework import APIView
from intranet.dogma.dogma.core.dao.source import source_by_code
from intranet.dogma.dogma.core.models import OrganisationsToClone


class OwnerView(APIView):
    def put(self, request, source, owner, **kwargs):
        source = source_by_code(source)
        if not source:
            raise Http404('source not found')
        if not OrganisationsToClone.objects.filter(source=source, name=owner).exists():
            OrganisationsToClone(
                source=source,
                name=owner
            ).save()
        return self.successful_response()
