# coding: utf-8
from rest_framework.response import Response
from django.http import Http404
from .content import ContentView


class ReadmeView(ContentView):
    def get(self, request, source, owner, name):
        commit = self.raw.get_object_by_refspec('HEAD')
        entries = self.raw.get_tree_entries(commit, '')
        for type_, fname, _ in entries:
            if type_ == 'file' and fname.lower().startswith('readme'):
                return super(ReadmeView, self).get(request, source, owner, name, fname)

        raise Http404('Not Found')
