# coding: utf-8

from dir_data_sync.org_ctx import get_org

from .base import BaseSerializer

from intranet.dogma.dogma.core.models import Credential


class CredentialSerializer(BaseSerializer):

    @property
    def validated_data(self):
        data = super(CredentialSerializer, self).validated_data
        data['connect_organization'] = get_org()
        return data

    class Meta:
        model = Credential
        fields = ('id', 'created', 'modified', 'auth_type',
                  'name', 'auth_data', 'is_success',
                  )
        read_only_fields = 'created', 'id', 'modified', 'is_success',

        extra_kwargs = {
            'auth_data': {'write_only': True},
        }
