# coding: utf-8

from .base import BaseSerializer
from .source import SourceSerializer
from .credential import CredentialSerializer
from .organization import OrganizationSerializer
from intranet.dogma.dogma.core.models import Repo


class RepoSerializer(BaseSerializer):
    source = SourceSerializer(read_only=True)
    credentials = CredentialSerializer(read_only=True, many=True)
    organisation = OrganizationSerializer(read_only=True)

    class Meta:
        model = Repo
        fields = ('id', 'vcs_name', 'name', 'owner',
                  'description', 'default_branch',
                  'known_commits', 'status',
                  'last_sync_success_time', 'last_sync_fail_time',
                  'error_value', 'source', 'url',
                  'credentials', 'organisation',
                  'last_sync_fail_error_code',
                  )
