# coding: utf-8
from django.conf.urls import url
from rest_framework import routers

from intranet.dogma.dogma.api import views as v3_views
from . import views

urlpatterns = [
    url(r'^search/commits/?$', v3_views.CommitsSearchView.as_view()),
    url(r'^search/commits/count/?$', v3_views.CommitsSearchCountView.as_view()),
]


router = routers.SimpleRouter()
router.register(r'resources/repo', views.RepoView, basename='repo_viewset')
router.register(r'resources/credential', views.CredentialView, basename='credential_viewset')
router.register(r'resources/organization', views.OrganizationView, basename='organization_viewset')
urlpatterns += router.urls
