# coding: utf-8

from rest_framework import viewsets

from intranet.dogma.dogma.core.models import Credential

from ..serializers import CredentialSerializer
from .base import BaseV4ApiView


class CredentialView(BaseV4ApiView, viewsets.ModelViewSet):
    model = Credential
    serializer_class = CredentialSerializer
    ordering = 'name', 'id',

    def get_queryset(self):
        return self.model.objects.get_objects_for_current_org()

    def perform_update(self, serializer):
        instance = serializer.save()
        for repo in instance.get_related_repos():
            repo.after_credentials_change()
