import os

from django.conf import settings
from celery import Task, Celery
from celery.concurrency import asynpool
from django_tools_log_context.celery import CtxAwareMixin

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'intranet.dogma.dogma.settings')

# https://github.com/celery/celery/issues/1715#issuecomment-50140150
# После обновления на celery выше 4.4.2 можно будет использовать параметр
# worker_proc_alive_timeout
asynpool.PROC_ALIVE_TIMEOUT = 60.0


class DogmaCeleryTask(CtxAwareMixin, Task):
    abstract = True


app = Celery('dogma', task_cls=DogmaCeleryTask)
app.config_from_object('django.conf:settings', namespace='CELERY')
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)
