# coding: utf-8


import re
import time

import grpc

from django.conf import settings

from arc.api.public import repo_pb2_grpc, repo_pb2

from intranet.dogma.dogma.core.errors import BaseError, NoRepositoryError
from .base import BaseRepo
from intranet.dogma.dogma.core.utils import get_repository_model
from ..models import PushedCommit


class Repo(BaseRepo):
    def get_url(self, credential=None):
        protocol = self.repo.source.vcs_protocol

        if protocol == 'native':
            return 'https://%s/arc_vcs/?rev=%s' % (
                self.repo.source.host,
                self.repo.vcs_name
            )

        return super(Repo, self).get_url()

    def base_clone_command(self, clone_branches=False, url_pattern=None, credential=None):
        # no local copy
        pass

    def has_new_commits(self):
        # ask for new commits always
        return True

    def base_fetch_command(self, credential=None):
        return self.has_new_commits()

    def recover(self):
        pass

    def commits_in_default_branch(self):
        return 0

    def get_commit_native_id(self, repo, commit):
        if commit._initial["commit"].SvnRevision:
            return "r" + str(commit._initial["commit"].SvnRevision)
        else:
            return commit.hex

