# coding: utf-8


import os
import logging

from django.conf import settings

from intranet.dogma.dogma.core.logic.credential import CredentialClass

log = logging.getLogger(__name__)


class BaseRepo(CredentialClass):

    def __init__(self, repo):
        self.repo = repo

    @property
    def path(self):
        return os.path.join(
            settings.DOGMA_ROOT,
            '%s/%s' % (self.repo.source.code, self.repo.owner),
            self.repo.name
        )

    def get_url(self, credential=None):
        protocol = self.repo.source.vcs_protocol

        raise ValueError('Protocol not supported: %s' % protocol)

    def clone(self, *args, **kwargs):
        return self.base_clone_command(*args, **kwargs)

    def base_clone_command(self, *args, **kwargs):
        raise NotImplementedError

    def fetch(self):
        return self.base_fetch_command()

    def base_fetch_command(self):
        raise NotImplementedError

    def get_commit_native_id(self, repo, commit):
        return commit.hex

    def commits_in_default_branch(self):
        """
        @rtype: int
        """
        raise NotImplementedError
