# coding: utf-8


import logging

from django.conf import settings

from .git import Repo as GitRepo

from intranet.dogma.dogma.core.models import Source

log = logging.getLogger(__name__)


class Repo(GitRepo):
    AUTH_TYPE = 'app_password'

    def get_url(self, credential=None):
        protocol = self.repo.source.vcs_protocol
        if settings.IS_BUSINESS:
            robot_login = settings.DOGMA_FETCH_USERNAME
            app_password = settings.DOGMA_BITBUCKET_APP_PASSWORD
            if credential:
                robot_login, app_password = self.get_credential_data(
                    credential,
                    (robot_login, app_password),
                )
                robot_login = robot_login.split('@')[0]

            return '%s://%s:%s@%s/%s' % (
                protocol,
                robot_login,
                app_password,
                self.repo.source.host, self.repo.vcs_name
            )

        if protocol in ('https', 'http'):
            if self.repo.source.web_auth == Source.WEB_AUTH_TYPES.basic:
                return '%s://%s:%s@%s/scm/%s' % (
                    protocol,
                    settings.DOGMA_FETCH_USERNAME,
                    settings.DOGMA_FETCH_PASSWORD,
                    self.repo.source.host,
                    self.repo.vcs_name
                )

            return '%s://x-oauth-token:%s@%s/scm/%s' % (
                protocol,
                settings.DOGMA_OAUTH_TOKEN,
                self.repo.source.host, self.repo.vcs_name
            )

        return super(GitRepo, self).get_url()
