# coding: utf-8


import logging

from django.conf import settings

from .git import Repo as GitRepo

log = logging.getLogger(__name__)


class Repo(GitRepo):
    CHECK_NEW = False

    def get_url(self, credential=None):
        protocol = self.repo.source.vcs_protocol

        if protocol == 'native':
            return 'git://%s/%s.git' % (self.repo.source.host, self.repo.vcs_name)
        elif protocol in ('https', 'http'):
            if settings.IS_BUSINESS:
                token = settings.DOGMA_GITHUB_EXT_TOKEN
                if credential:
                    token = self.get_credential_data(credential, token)

                return '%s://%s:x-oauth-basic@%s/%s.git' % (
                    protocol,
                    token,
                    self.repo.source.host,
                    self.repo.vcs_name
                )
            return '%s://%s:%s@%s/%s.git' % (
                protocol,
                settings.DOGMA_FETCH_USERNAME,
                settings.DOGMA_GITHUB_INT_TOKEN,
                self.repo.source.host,
                self.repo.vcs_name
            )
        elif protocol == 'ssh':
            return 'git@%s:%s.git' % (self.repo.source.host, self.repo.vcs_name)

        return super(GitRepo, self).get_url()
