# coding: utf-8


from django.conf import settings
from django.core.exceptions import ImproperlyConfigured

from .git import Repo as GitRepo


class Repo(GitRepo):
    def get_url(self, credential=None):
        protocol = self.repo.source.vcs_protocol
        token = self._get_token()
        if settings.IS_BUSINESS:
            if credential:
                token = self.get_credential_data(credential, token)
            login = 'oauth2'
        else:
            login = settings.DOGMA_FETCH_USERNAME

        vcs_name = self.repo.vcs_name
        if not vcs_name.endswith('.git'):
            vcs_name = '{}.git'.format(vcs_name)

        if protocol in ('https', 'http'):
            return '{}://{}:{}@{}/{}'.format(
                protocol,
                login,
                token,
                self.repo.source.host,
                vcs_name,
            )

        return super(GitRepo, self).get_url()

    def _get_token(self):
        if self.repo.source.extra_info.get('token'):
            return self.repo.source.extra_info['token']
        raise ImproperlyConfigured(
            'Go to admin and add {"token": "token"} to Source\'s extra_info'
        )
