# coding: utf-8



from .git_web import GitWebCrawler
from .web_svn import WebSvnCrawler
from .github import GithubCrawler
from .hg_web import HgWebCrawler
from .stash import StashCrawler
from .gitlab import GitlabCrawler
from .bitbucket import BitBucketCrawler
from .gerrit import GerritCrawler
from .bitbucket_yateam import BBCrawler
from .arc import ArcCrawler


def get_crawler(source):
    crawler_types = {
        'github': GithubCrawler,
        'websvn': WebSvnCrawler,
        'gitweb': GitWebCrawler,
        'hgweb': HgWebCrawler,
        'stash': StashCrawler,
        'gitlab': GitlabCrawler,
        'bitbucket_ext': BitBucketCrawler,
        'bitbucket_yateam': BBCrawler,
        'gerrit': GerritCrawler,
        'arc': ArcCrawler,
    }

    return crawler_types[source.web_type](source)
