# coding: utf-8



import logging
from time import sleep

from cached_property import cached_property
from django.core.exceptions import ImproperlyConfigured
from django.utils.encoding import force_text

from intranet.dogma.dogma.core.models import Source
from .base import RepoCrawler, RepoTuple


log = logging.getLogger(__name__)


class ArcCrawler(RepoCrawler):

    def _get_token(self):
        if self.source.extra_info.get('token'):
            return self.source.extra_info['token']
        raise ImproperlyConfigured(
            'Go to admin and add {"token": "token"} to Source\'s extra_info'
        )

    def get_repos(self, **kwargs):
        return []

    def get_repo_url(self, repo):
        return 'https://%s/arc_vcs/?rev=%s' % (
            repo.source.host,
            repo.vcs_name
        )

    def get_commit_url(self, repo, id_):
        if repo.vcs_name == 'trunk':
            return 'https://a.yandex-team.ru/arc/commit/{}'.format(id_)
        else:
            return 'https://a.yandex-team.ru/arc_vcs/commit/{}'.format(id_)
