# coding: utf-8



import urllib.parse

from .stash import StashCrawler


class BitBucketCrawler(StashCrawler):

    def get_request_data(self, project_key, credential, next_url):
        team, project = project_key.split('-')
        base_params = self.get_auth(credential=credential)
        base_params['params'] = {
            'q': 'project.key=\"{}\"'.format(project),
        }
        if next_url:
            url = next_url
        else:
            api_url = self.source.extra_info['api_url']
            url = urllib.parse.urljoin(api_url, '/2.0/repositories/{}'.format(team))
        return url, base_params

    def get_repo_url(self, repo):
        return '%s/%s/%s' % (repo.source.web_url, repo.owner, repo.name)

    def get_commit_url(self, repo, id_):
        return '%s/%s/%s/commits/%s' % (repo.source.web_url, repo.owner, repo.name, id_)
