# coding: utf-8


import logging

from .stash import StashCrawler

from requests.exceptions import RequestException

log = logging.getLogger(__name__)


class BBCrawler(StashCrawler):

    def is_repo_public(self, project, repo):
        url = self._make_url(
            type='{}/{}'.format(project, repo['name']), start=None,
            path='/rest/public-repo/1.0/check/repo/',
        )
        try:
            return self._get_url(url=url)
        except RequestException:
            log.warning('Got error while checking repo public status for "{}"'.format(repo['name']))
            return False
