# coding: utf-8



from lxml import etree

from django.utils.encoding import force_text

from .base import RepoCrawler, RepoTuple


class WebSvnCrawler(RepoCrawler):
    def get_repos(self, **kwargs):
        auth = self.get_auth()

        response = self.session.get(
            url=self.source.web_url, **auth
        )

        response.raise_for_status()

        doc = etree.fromstring(response.content, parser=etree.HTMLParser())

        for node in doc.xpath("//td[@class='project']/a"):
            yield RepoTuple(
                name=force_text(self.normalize_name(node.text)),
                owner='root',
                description='',
                vcs_name=force_text(node.text),
                default_branch='master',
                is_public=True,
            )

    def get_repo_url(self, repo):
        """
        Для svn версии аркадии особая логика.
        """
        if 'arcadia.yandex.ru' in repo.source.web_url:
            return 'https://a.yandex-team.ru'
        return '%s/%s' % (self.source.web_url, repo.vcs_name)

    def get_commit_url(self, repo, id_):
        if 'arcadia.yandex.ru' in repo.source.web_url:
            return self.get_repo_url(repo) + '/commit/' + id_
        return self.get_repo_url(repo) + '?op=revision&rev=%s' % id_
